/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models.generators.block;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_4590;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BlockModelBuilder
extends ModelBuilder<BlockModelBuilder> {
    private final RootTransformBuilder rootTransform = new RootTransformBuilder();

    public BlockModelBuilder(class_2960 outputLocation, ExistingFileHelper existingFileHelper) {
        super(outputLocation, existingFileHelper);
    }

    public RootTransformBuilder rootTransform() {
        return this.rootTransform;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        JsonObject transform = this.rootTransform.toJson();
        if (transform.size() > 0) {
            json.add("transform", (JsonElement)transform);
        }
        return json;
    }

    public static Quaternionf quatFromXYZ(float x, float y, float z, boolean degrees) {
        float conversionFactor = degrees ? (float)Math.PI / 180 : 1.0f;
        return new Quaternionf().rotationXYZ(x * conversionFactor, y * conversionFactor, z * conversionFactor);
    }

    public class RootTransformBuilder {
        private static final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
        private Vector3f translation = new Vector3f();
        private Quaternionf leftRotation = new Quaternionf();
        private Quaternionf rightRotation = new Quaternionf();
        private Vector3f scale = ONE;
        @Nullable
        private TransformOrigin origin;
        @Nullable
        private Vector3f originVec;

        private RootTransformBuilder() {
        }

        public RootTransformBuilder translation(Vector3f translation) {
            this.translation = (Vector3f)Preconditions.checkNotNull((Object)translation, (Object)"Translation must not be null");
            return this;
        }

        public RootTransformBuilder translation(float x, float y, float z) {
            return this.translation(new Vector3f(x, y, z));
        }

        public RootTransformBuilder rotation(Quaternionf rotation) {
            this.leftRotation = (Quaternionf)Preconditions.checkNotNull((Object)rotation, (Object)"Rotation must not be null");
            return this;
        }

        public RootTransformBuilder rotation(float x, float y, float z, boolean isDegrees) {
            return this.rotation(BlockModelBuilder.quatFromXYZ(x, y, z, isDegrees));
        }

        public RootTransformBuilder leftRotation(Quaternionf leftRotation) {
            return this.rotation(leftRotation);
        }

        public RootTransformBuilder leftRotation(float x, float y, float z, boolean isDegrees) {
            return this.leftRotation(BlockModelBuilder.quatFromXYZ(x, y, z, isDegrees));
        }

        public RootTransformBuilder rightRotation(Quaternionf rightRotation) {
            this.rightRotation = (Quaternionf)Preconditions.checkNotNull((Object)rightRotation, (Object)"Rotation must not be null");
            return this;
        }

        public RootTransformBuilder rightRotation(float x, float y, float z, boolean isDegrees) {
            return this.rightRotation(BlockModelBuilder.quatFromXYZ(x, y, z, isDegrees));
        }

        public RootTransformBuilder postRotation(Quaternionf postRotation) {
            return this.rightRotation(postRotation);
        }

        public RootTransformBuilder postRotation(float x, float y, float z, boolean isDegrees) {
            return this.postRotation(BlockModelBuilder.quatFromXYZ(x, y, z, isDegrees));
        }

        public RootTransformBuilder scale(float scale) {
            return this.scale(new Vector3f(scale, scale, scale));
        }

        public RootTransformBuilder scale(float xScale, float yScale, float zScale) {
            return this.scale(new Vector3f(xScale, yScale, zScale));
        }

        public RootTransformBuilder scale(Vector3f scale) {
            this.scale = (Vector3f)Preconditions.checkNotNull((Object)scale, (Object)"Scale must not be null");
            return this;
        }

        public RootTransformBuilder transform(class_4590 transformation) {
            Preconditions.checkNotNull((Object)transformation, (Object)"Transformation must not be null");
            this.translation = transformation.method_35865();
            this.leftRotation = transformation.method_22937();
            this.rightRotation = transformation.method_35867();
            this.scale = transformation.method_35866();
            return this;
        }

        public RootTransformBuilder origin(Vector3f origin) {
            this.originVec = (Vector3f)Preconditions.checkNotNull((Object)origin, (Object)"Origin must not be null");
            this.origin = null;
            return this;
        }

        public RootTransformBuilder origin(TransformOrigin origin) {
            this.origin = (TransformOrigin)((Object)Preconditions.checkNotNull((Object)((Object)origin), (Object)"Origin must not be null"));
            this.originVec = null;
            return this;
        }

        public BlockModelBuilder end() {
            return BlockModelBuilder.this;
        }

        public JsonObject toJson() {
            JsonObject transform = new JsonObject();
            if (!this.translation.equals(0.0f, 0.0f, 0.0f)) {
                transform.add("translation", (JsonElement)this.writeVec3(this.translation));
            }
            if (!this.scale.equals((Object)ONE)) {
                transform.add("scale", (JsonElement)this.writeVec3(this.scale));
            }
            if (!this.leftRotation.equals(0.0f, 0.0f, 0.0f, 1.0f)) {
                transform.add("rotation", (JsonElement)this.writeQuaternion(this.leftRotation));
            }
            if (!this.rightRotation.equals(0.0f, 0.0f, 0.0f, 1.0f)) {
                transform.add("post_rotation", (JsonElement)this.writeQuaternion(this.rightRotation));
            }
            if (this.origin != null) {
                transform.addProperty("origin", this.origin.method_15434());
            } else if (this.originVec != null && !this.originVec.equals(0.0f, 0.0f, 0.0f)) {
                transform.add("origin", (JsonElement)this.writeVec3(this.originVec));
            }
            return transform;
        }

        private JsonArray writeVec3(Vector3f vector) {
            JsonArray array = new JsonArray();
            array.add((Number)Float.valueOf(vector.x()));
            array.add((Number)Float.valueOf(vector.y()));
            array.add((Number)Float.valueOf(vector.z()));
            return array;
        }

        private JsonArray writeQuaternion(Quaternionf quaternion) {
            JsonArray array = new JsonArray();
            array.add((Number)Float.valueOf(quaternion.x()));
            array.add((Number)Float.valueOf(quaternion.y()));
            array.add((Number)Float.valueOf(quaternion.z()));
            array.add((Number)Float.valueOf(quaternion.w()));
            return array;
        }

        public static enum TransformOrigin implements class_3542
        {
            CENTER(new Vector3f(0.5f, 0.5f, 0.5f), "center"),
            CORNER(new Vector3f(), "corner"),
            OPPOSING_CORNER(ONE, "opposing-corner");

            private final Vector3f vec;
            private final String name;

            private TransformOrigin(Vector3f vec, String name) {
                this.vec = vec;
                this.name = name;
            }

            public Vector3f getVector() {
                return this.vec;
            }

            @NotNull
            public String method_15434() {
                return this.name;
            }

            @Nullable
            public static TransformOrigin fromString(String originName) {
                if (CENTER.method_15434().equals(originName)) {
                    return CENTER;
                }
                if (CORNER.method_15434().equals(originName)) {
                    return CORNER;
                }
                if (OPPOSING_CORNER.method_15434().equals(originName)) {
                    return OPPOSING_CORNER;
                }
                return null;
            }
        }
    }
}

